/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.info.Beastiary;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageBeastiary
implements IMessage,
IMessageHandler<MessageBeastiary, IMessage> {
    public int entryAmount = 0;
    public String[] creatureNames;
    public double[] completions;

    public MessageBeastiary() {
    }

    public MessageBeastiary(Beastiary beastiary) {
        this.entryAmount = beastiary.creatureKnowledgeList.size();
        if (this.entryAmount > 0) {
            this.creatureNames = new String[this.entryAmount];
            this.completions = new double[this.entryAmount];
            int i = 0;
            for (CreatureKnowledge creatureKnowledge : beastiary.creatureKnowledgeList.values()) {
                this.creatureNames[i] = creatureKnowledge.creatureName;
                this.completions[i] = creatureKnowledge.completion;
                ++i;
            }
        }
    }

    public IMessage onMessage(MessageBeastiary message, MessageContext ctx) {
        if (ctx.side != Side.CLIENT) {
            return null;
        }
        EntityPlayer player = LycanitesMobs.proxy.getClientPlayer();
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return null;
        }
        if (message.entryAmount < 0) {
            return null;
        }
        HashMap<String, CreatureKnowledge> newKnowledgeList = new HashMap<String, CreatureKnowledge>();
        for (int i = 0; i < message.entryAmount; ++i) {
            String creatureName = message.creatureNames[i];
            double completion = message.completions[i];
            CreatureKnowledge creatureKnowledge = new CreatureKnowledge(playerExt.getBeastiary(), creatureName, completion);
            newKnowledgeList.put(creatureKnowledge.creatureName, creatureKnowledge);
        }
        playerExt.getBeastiary().newKnowledgeList(newKnowledgeList);
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        this.entryAmount = packet.readInt();
        if (this.entryAmount > 0) {
            this.creatureNames = new String[this.entryAmount];
            this.completions = new double[this.entryAmount];
            for (int i = 0; i < this.entryAmount; ++i) {
                this.creatureNames[i] = packet.func_150789_c(256);
                this.completions[i] = packet.readDouble();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        packet.writeInt(this.entryAmount);
        if (this.entryAmount > 0) {
            for (int i = 0; i < this.entryAmount; ++i) {
                packet.func_180714_a(this.creatureNames[i]);
                packet.writeDouble(this.completions[i]);
            }
        }
    }
}

